using System;
using System.Collections.Generic;
using System.Linq;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class DATA_DICTIONARYDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public DATA_DICTIONARYDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public List<DATA_DICTIONARY> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<DATA_DICTIONARY> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_DATA_DICTIONARY_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        #endregion
    }
}
